<?php $settingInformation = settingArr(); ?>

<!-- Start Footer
============================================= -->
<footer>
    <div class="footer-t">
        <div class="container">
            <div class="row">
                <!-- Column 1 -->
                <div class="col-lg-3 col-md-6 col-sm-6 border-md-only">
                    <strong class="logo">
                        <a href="<?php echo e(url('/home')); ?>">
                            <img src="<?php echo e(asset_storage('front/images/logo.png')); ?>" alt="Catalyst Partners" width="264" height="69">
                        </a>
                    </strong>
                    <ul class="info-lists">
                        <li>
                            <div class="ico">
                                <img src="<?php echo e(asset_storage('front/images/ico-phone-white.png')); ?>" alt="ico phone" width="26" height="26">
                            </div>
                            <div class="txt">
                                <span class="call">Call now</span>
                                <a class="tel" href="tel:<?php echo $settingInformation['telephone']; ?>">
                                    <?php echo $settingInformation['telephone']; ?>
                                </a>
                            </div>
                        </li>
                        <li>
                            <div class="ico">
                                <i class="fa-regular fa-envelope"></i>
                            </div>
                            <div class="txt">
                                <span class="call">Email:</span>
                                <a class="mail" href="mailto:<?php echo $settingInformation['email']; ?>">
                                    <?php echo $settingInformation['email']; ?>
                                </a>
                            </div>
                        </li>
                        <li>
                            <div class="ico">
                                <i class="fa-solid fa-location-dot"></i>
                            </div>
                            <div class="txt">
                                <address class="address">
                                    <a href="#"><?php echo $settingInformation['address']; ?></a>
                                </address>
                            </div>
                        </li>
                    </ul>
                </div>

                <!-- Column 2 -->
                <div class="col-lg-2 col-md-6 col-sm-6 border-md-only">
                    <strong class="title text-start text-sm-center text-lg-start">Quick Links</strong>
                    <ul class="sub-nav quicklinks">
                        <?php $isactive = Request::segment(1) == null ? ' active' : ''; ?>
                        <?php echo getDropDown(); ?>
                    </ul>
                </div>

                <!-- Column 3 -->
                <div class="col-lg-4 col-md-6 col-sm-6 pt-0 pt-sm-4 pt-md-5 pt-lg-0">
                    <strong class="title">Core Services</strong>
                    <ul class="sub-nav">
                        <?php
                            $get_all_services = \App\Models\Back\Service::where('is_featured', 1)->active()->sorted()->get();
                        ?>
                        <?php if(count($get_all_services) > 0): ?>
                            <?php $__currentLoopData = $get_all_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $services): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(url('services/'.$services->slug)); ?>"><?php echo e($services->title); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </ul>
                </div>

                <!-- Column 4 -->
                <div class="col-lg-3 col-md-6 col-sm-6 pt-0 pt-sm-4 pt-md-5 pt-lg-0">
                    <strong class="title text-start text-sm-center text-lg-start">Industry Newsletter</strong>
                    <div class="form-holder">
                        <form action="#">
                            <div class="holder">
                                <input type="email" placeholder="Email Address" class="form-control">
                                <button type="submit" class="btn-submit">
                                    <img src="<?php echo e(asset_storage('front/images/ico-submit.png')); ?>" alt="ico submit" width="20" height="20">
                                </button>
                            </div>
                        </form>
                    </div>
                    <ul class="social">
                        <?php echo social_media(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer Bottom -->
    <div class="footer-b">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-8">
                    <p>Copyright &copy; 2025 Catalyst SC Partners. All Rights Reserved.</p>
                </div>
                <div class="col-lg-6 col-md-4">
                    <p class="text-md-end">
                        Site Credits: <a href="https://www.medialinkers.com" target="_blank">MediaLinkers</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- End Footer -->
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/catalyst/site_files/resources/views/front/common_views/footer.blade.php ENDPATH**/ ?>