<?php
    if (isset($_SERVER['HTTP_REFERER']) && !empty($_SERVER['HTTP_REFERER'])) {
        $hostname = parse_url($_SERVER['HTTP_REFERER'], PHP_URL_HOST);
        if (stripos(url('/'), $hostname) === false) {
            $leadStatUrls = \App\Models\Back\LeadStatUrl::where('url_internal_external', 'like', 'external')->get();
            foreach ($leadStatUrls as $leadStatUrlObj) {
                if (stripos($_SERVER['HTTP_REFERER'], $leadStatUrlObj->url) !== false) {
                    $referrer = $leadStatUrlObj->referrer;
                    session()->put('referrer', $referrer);
                }
            }
        }
    }
?>

<!-- ========== Meta & Favicon ========== -->
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Catalyst SC Partners</title>

<link rel="shortcut icon" href="<?php echo e(asset_storage('front/images/favicon.ico')); ?>" type="image/x-icon">
<link rel="icon" href="<?php echo e(asset_storage('front/images/favicon.ico')); ?>" type="image/x-icon">

<!-- ========== Stylesheets ========== -->
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Archivo:ital,wght@0,100..900;1,100..900&family=Instrument+Sans:ital,wght@0,400..700;1,400..700&family=Montserrat:ital,wght@0,100..900;1,100..900&family=Open+Sans:ital,wght@0,300..800;1,300..800&display=swap" rel="stylesheet">

<link rel="stylesheet" href="<?php echo e(asset_storage('front/css/fontawesome.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset_storage('front/css/bootstrap.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset_storage('front/css/flexslider.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset_storage('front/rs-plugin/css/settings.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset_storage('front/css/style.css')); ?>">

<!--[if lt IE 9]>
    <script src="<?php echo e(asset_storage('front/js/html5/html5shiv.min.js')); ?>"></script>
    <script src="<?php echo e(asset_storage('front/js/html5/respond.min.js')); ?>"></script>
<![endif]-->

<!-- ========== Google Fonts (Fallback) ========== -->
<link href="https://fonts.googleapis.com/css?family=Open+Sans" rel="stylesheet">
<link href="https://fonts.googleapis.com/css?family=Poppins:400,500,600,700,800" rel="stylesheet">

<!-- ========== Inline Styles ========== -->
<style>
    .before,
    .after {
        margin: 0;
    }

    .before figcaption,
    .after figcaption {
        background: #fff;
        border: 1px solid #c0c0c0;
        border-radius: 12px;
        color: #2e3452;
        opacity: 0.8;
        padding: 12px;
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        line-height: 100%;
    }

    .before figcaption { left: 12px; }
    .after figcaption { right: 12px; }

    img-comparison-slider {
        --divider-width: 4px;
        --divider-color: #ffffff;
        --default-handle-opacity: 1;
        --default-handle-width: 150px;
        --default-handle-shadow: 2px 4px 6px #000;
    }
</style>

<script>
    var base_url = "<?php echo e(base_url()); ?>";
</script>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/catalyst/site_files/resources/views/front/common_views/before_head_close.blade.php ENDPATH**/ ?>