jQuery(function(){
    initAddClass();
	initSlickSlider();
    initRevolutionSlider();
});

function initAddClass() {
    $('#header .navbar-toggler').on('click', function () {
        $('body').toggleClass('nav-active');
    });

    $('#header .close-toggler').on('click', function () {
        $('.navbar-collapse').removeClass('show');
        $('body').removeClass('nav-active'); 
    });
}

function initSlickSlider(){
    $('.core-slick-slider').slick({
        centerMode: false,
        variableWidth: false,
        cssEase: 'ease-in-out',
        arrows: true,
        dots: false,
        infinite: true,
        speed: 300,
        autoplay: true,
        autoplaySpeed: 2000,
        slidesToShow: 3,
        slidesToScroll: 1,
        prevArrow: '<button type="button" class="slick-prev"><i class="fa-solid fa-chevron-left"></i></button>',
        nextArrow: '<button type="button" class="slick-next"><i class="fa-solid fa-chevron-right"></i></button>',
        responsive: [
            {
            breakpoint: 1199,
                settings: {
                    centerMode: false,
                    slidesToShow: 3
                }
            },
            {
            breakpoint: 991,
                settings: {
                    slidesToShow: 2
                }
            },
            {
            breakpoint: 574,
                settings: {
                    slidesToShow: 1
                }
            }
        ]
    });

    $('.testimonial-slider').slick({
        centerMode: false,
        variableWidth: false,
        fade: true,
        cssEase: 'linear',
        arrows: true,
        dots: true,
        infinite: true,
        speed: 300,
        autoplay: true,
        autoplaySpeed: 2000,
        slidesToShow: 1,
        slidesToScroll: 1,
        prevArrow: '<button type="button" class="slick-prev"><i class="fa-solid fa-chevron-left"></i></button>',
        nextArrow: '<button type="button" class="slick-next"><i class="fa-solid fa-chevron-right"></i></button>',
    });

}

function initRevolutionSlider() {
    (function($) { 
        
        /* ================ Revolution Slider. ================ */
        if($('.tp-banner').length > 0){
            $('.tp-banner').show().revolution({
                delay:6000,
                startheight: 850,
                startwidth: 1170,
                hideThumbs: 1000,
                navigationType: 'none',
                touchenabled: 'on',
                onHoverStop: 'on',
                navOffsetHorizontal: 0,
                navOffsetVertical: 0,
                dottedOverlay: 'none',
                fullWidth: 'on'
            });
        }
        if($('.tp-banner-full').length > 0){
            $('.tp-banner-full').show().revolution({
                delay:6000,
                hideThumbs: 1000,
                navigationType: 'none',
                touchenabled: 'on',
                onHoverStop: 'on',
                navOffsetHorizontal: 0,
                navOffsetVertical: 0,
                dottedOverlay: 'none',
                fullScreen: 'on'
            });
        }	
        
    })(jQuery);
}