@extends('front.layout.app')
@section('beforeHeadClose')
<link href="{{ asset_storage('') . 'module/blog/front/css/blog.css' }}" rel="stylesheet" type="text/css" />
<script src='https://www.google.com/recaptcha/api.js'></script>
<style>
    .error-bg {
        background-color: #e6cfcf;
    }

    .error {
        color: #FF0000;
    }
</style>
@endsection
@section('content')
@php $settingArr = settingArr(); @endphp
@php
//echo cms_page_heading('Contact us',118)
@endphp
@php echo cms_edit_page('cms',$data->id);@endphp
<div class="about-wrap">
    <!-- Start Breadcrumb
                                                                                        ============================================= -->
    <!-- Breadcrumbs start -->
    <section class="breadcrumbs-wrap">
        <div class="container">
            <h1>Contact Us</h1>
        </div>
    </section>
    <!-- Breadcrumbs end -->
    <main id="main">

        <section class="pagecontent-wrap">
            <div class="container">
                <div class="contact-wrap">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="coninfo">
                                <h2>Get In Touch</h2>
                                <p class="my-3"> {!! $data->content !!}</p>
                            </div>
                            <div class="d-md-flex flex-column d-block text-center text-md-start">
                                @if (!empty($settingArr->address))
                                <div class="d-md-flex gap-3 p-0 align-items-center d-block text-center text-lg-start infoText">
                                    <i class="fa-solid fa-house"></i>
                                    <p class="address-text"><a href="#">{{ $settingArr->address }}</a></p>
                                </div>
                                @endif
                                <div class="d-md-flex gap-3 p-0 align-items-center d-block text-center text-lg-start infoText">
                                    <i class="fa-solid fa-phone"></i>
                                    <p><a href="tel:{{ strip_tags($settingArr->telephone) }}">{{ strip_tags($settingArr->telephone) }}</a></p>
                                </div>

                                <div class="d-md-flex gap-3 p-0 align-items-center d-block text-center text-lg-start infoText">
                                    <i class="fa-solid fa-envelope"></i>
                                    <p><a href="mailto:{{ strip_tags($settingArr->email) }}">{{ strip_tags($settingArr->email) }}</a></p>
                                </div>
                                <div class="d-flex socialicons justify-content-center gap-3">
                                    @php echo social_media(); @endphp
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="conForm">
                                <form id="contactFrom">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <input type="text" class="form-control" name="name" placeholder="Your Name" value="{{ old('name') }}" >
                                            <div id="name-error" class="error"></div>
                                        </div>
                                        <div class="col-lg-6">
                                            <input type="email" class="form-control" name="email" placeholder="Email Address" value="{{ old('email') }}" >
                                            <div id="email-error" class="error"></div>
                                        </div>
                                        <div class="col-lg-6">
                                            <input type="tel" class="form-control" name="phone" placeholder="Phone Number" value="{{ old('phone') }}" >
                                            <div id="phone-error" class="error"></div>
                                        </div>
                                        <div class="col-lg-6">
                                            <input type="text" class="form-control" name="company_name" placeholder="Company Name" value="{{ old('company_name') }}">
                                            <div id="company_name-error" class="error"></div>
                                        </div>
                                        <div class="col-lg-12">
                                            <input type="text" class="form-control" name="subject" placeholder="Subject" value="{{ old('subject') }}">
                                            <div id="subject-error" class="error"></div>
                                        </div>
                                        <div class="col-lg-12">
                                            <textarea name="message" class="form-control" placeholder="Comment"></textarea>
                                        
                                        </div>
                                        <div class="col-lg-12">
                                            <button type="button" onclick="submitContactFormAjax();" class="hover2">Submit</button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>

    </main>
</div>
@endsection
@section('beforeBodyClose')
<script>
function submitContactFormAjax() {
    let form = document.getElementById('contactFrom');
    let formData = new FormData(form);

    // Clear previous errors
    document.querySelectorAll('.error').forEach(el => el.innerHTML = '');

    fetch("{{ url('contact-us/save') }}", {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value,
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if(data.status === false && data.errors) {
            // show validation errors
            for (const key in data.errors) {
                if (data.errors.hasOwnProperty(key)) {
                    let errorEl = document.getElementById(`${key}-error`);
                    if(errorEl) errorEl.innerText = data.errors[key][0];
                }
            }
        } else {
            // reset the form
            form.reset();

            // show success modal
            const modalHtml = `
                <div class="modal fade" id="contactSuccessModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <img src="{{ asset_storage('front/images/icons/submitted.gif') }}" alt="submitIcon">
                            <div>
                                <h3>Response Submitted</h3>
                                <h6>Your Details have been successfully submitted. Thanks</h6>
                            </div>
                            <button type="button" class="hover1 m-auto" data-bs-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>`;
            
            if(!document.getElementById('contactSuccessModal')) {
                document.body.insertAdjacentHTML('beforeend', modalHtml);
            }

            const modal = new bootstrap.Modal(document.getElementById('contactSuccessModal'));
            modal.show();
        }
    })
    .catch(error => console.error('Error:', error));
}
</script>


@endsection